


# to echo output, use 'source("main.R", echo=TRUE)'

# clear workspace
rm(list=ls())

# load libraries
library("ggplot2")
library("reshape2")

# source and generate data
source("generate.R")

p0 <- ggplot(email, aes(x=as.factor(Team), y = responseTime)) +
  geom_boxplot(aes(fill=as.factor(Team))) +
  xlab("team") +
  ylab("response time (s)") +
  #coord_flip() +
  scale_fill_grey(name="team")
# save graph to file
ggsave(file="boxplots_response_times.png")
ggsave(file="boxplots_response_times.pdf")

# boxplot with flipped axes
p1 <- ggplot(email, aes(x=as.factor(Team), y = responseTime)) +
  #facet_grid() +
  #facet_grid(. ~ Team) +
  #facet_grid(Team ~ .) +
  geom_jitter() + #coord_cartesian(xlim = c(-100, 10)) + 
  geom_boxplot(aes(fill=as.factor(Time))) + 
  #geom_violin(aes(fill=as.factor(Time))) + 
  #xlab("team") +
  xlab(" ") +
  ylab("response time (s)") +
  ggtitle("Response times of teams over 3 months") +
  #coord_flip() + 
  scale_fill_grey(name="month") +
  scale_color_grey() +
  theme_bw() #+
  #increase size of gridlines
  #theme(panel.grid.major = element_line(size = .5, color = "grey"),
  #      #increase size of axis lines
  #      axis.line = element_line(size=.7, color = "black"),
  #      #Adjust legend position to maximize space, use a vector of proportion
  #      #across the plot and up the plot where you want the legend. 
  #      #You can also use "left", "right", "top", "bottom", for legends on t
  #      #he side of the plot
  #      legend.position = c(.85,.7),
  #      #increase the font size
  #      text = element_text(size=14)) 
# save graph to file
ggsave(file="boxplots_response_times_by_time.png")
ggsave(file="boxplots_response_times_by_time.pdf")



